/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshaftsCommon;
import com.yungnickyoung.minecraft.bettermineshafts.module.StructurePieceTypeModule;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.util.BoundingBoxHelper;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2399;
import net.minecraft.class_2487;
import net.minecraft.class_2533;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3865;
import net.minecraft.class_3866;
import net.minecraft.class_39;
import net.minecraft.class_5138;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;

public class SideRoom
extends BetterMineshaftPiece {
    private boolean hasDownstairs;
    private static final int SECONDARY_AXIS_LEN = 10;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 9;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 4;

    public SideRoom(class_2487 compoundTag) {
        super(StructurePieceTypeModule.SIDE_ROOM, compoundTag);
        this.hasDownstairs = compoundTag.method_10577("hasDownstairs");
    }

    public SideRoom(int pieceChainLen, class_3341 blockBox, class_2350 direction, BetterMineshaftConfiguration config) {
        super(StructurePieceTypeModule.SIDE_ROOM, pieceChainLen, config, blockBox);
        this.method_14926(direction);
    }

    @Override
    protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
        super.method_14943(structurePieceSerializationContext, compoundTag);
        compoundTag.method_10556("hasDownstairs", this.hasDownstairs);
    }

    public static class_3341 determineBoxPosition(class_6130 structurePiecesHolder, int x, int y, int z, class_2350 direction) {
        class_3341 blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)10, (int)5, (int)5, (class_2350)direction);
        class_3443 intersectingPiece = structurePiecesHolder.method_35461(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void method_14918(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource) {
        if ((double)randomSource.method_43057() < BetterMineshaftsCommon.CONFIG.spawnRates.workstationDungeonSpawnRate) {
            class_2350 direction = this.method_14934();
            if (direction == null) {
                return;
            }
            BetterMineshaftPiece newDungeonPiece = null;
            switch (direction) {
                case field_11043: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() + 6, this.field_15315.method_35416() - 4, this.field_15315.method_35420(), this.method_14934(), this.field_15316);
                    break;
                }
                case field_11035: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() + 6, this.field_15315.method_35416() - 4, this.field_15315.method_35417(), this.method_14934(), this.field_15316);
                    break;
                }
                case field_11039: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418(), this.field_15315.method_35416() - 4, this.field_15315.method_35417() + 6, this.method_14934(), this.field_15316);
                    break;
                }
                case field_11034: {
                    newDungeonPiece = BetterMineshaftGenerator.generateAndAddSideRoomDungeonPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415(), this.field_15315.method_35416() - 4, this.field_15315.method_35417() + 6, this.method_14934(), this.field_15316);
                }
            }
            if (newDungeonPiece != null) {
                this.hasDownstairs = true;
            }
        }
    }

    public void method_14931(class_5281 world, class_5138 structureManager, class_2794 chunkGenerator, class_5819 randomSource, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        this.fill(world, box, randomSource, 0, 0, 0, 9, 1, 4, this.config.blockStateRandomizers.brickRandomizer);
        this.chanceReplaceNonAir(world, box, randomSource, 1.0f, 0, 2, 0, 9, 3, 4, this.config.blockStateRandomizers.brickRandomizer);
        this.fill(world, box, 1, 1, 1, 8, 3, 4, AIR);
        boolean[][] ceiling = new boolean[10][5];
        for (int x = 0; x <= 9; ++x) {
            for (int z = 0; z <= 4; ++z) {
                class_2680 currState = this.getBlockAtFixed((class_1922)world, x, 4, z, box);
                if (currState == null || currState == AIR || currState == class_2246.field_10124.method_9564()) continue;
                this.method_14917(world, this.config.blockStateRandomizers.brickRandomizer.get(randomSource), x, 4, z, box);
                ceiling[x][z] = true;
            }
        }
        if (!this.hasDownstairs) {
            this.generateLegs(world, randomSource, box);
        }
        if (randomSource.method_43048(2) == 0) {
            this.method_14917(world, (class_2680)class_2246.field_10181.method_9564().method_11657((class_2769)class_3865.field_11104, (Comparable)class_2350.field_11043), 2, 1, 1, box);
            class_2586 blockEntity = world.method_8321((class_2338)this.method_33781(2, 1, 1));
            if (blockEntity instanceof class_3866) {
                ((class_3866)blockEntity).method_5447(1, new class_1799((class_1935)class_1802.field_8713, randomSource.method_43048(33)));
            }
        }
        if (randomSource.method_43048(2) == 0) {
            this.method_14917(world, (class_2680)class_2246.field_10181.method_9564().method_11657((class_2769)class_3865.field_11104, (Comparable)class_2350.field_11043), 1, 1, 1, box);
            class_2586 blockEntity = world.method_8321((class_2338)this.method_33781(1, 1, 1));
            if (blockEntity instanceof class_3866) {
                ((class_3866)blockEntity).method_5447(1, new class_1799((class_1935)class_1802.field_8713, randomSource.method_43048(33)));
            }
        }
        this.chanceAddBlock(world, randomSource, 0.5f, class_2246.field_9980.method_9564(), 3, 1, 1, box);
        if (randomSource.method_43048(4) == 0) {
            this.addBarrel(world, box, randomSource, 8, 1, 1, (class_5321<class_52>)class_39.field_472);
        }
        if (this.hasDownstairs) {
            this.method_14917(world, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11043), 6, 0, 1, box);
            class_2680 trapdoorBlockState = this.config.blockStates.trapdoorBlockState;
            if (trapdoorBlockState.method_28498((class_2769)class_2533.field_11177)) {
                trapdoorBlockState = (class_2680)trapdoorBlockState.method_11657((class_2769)class_2533.field_11177, (Comparable)class_2350.field_11043);
            }
            this.method_14917(world, trapdoorBlockState, 6, 1, 1, box);
        }
        this.generateIronBarSupports(world, box, randomSource, ceiling);
        this.addBiomeDecorations(world, box, randomSource, 0, 0, 0, 9, 3, 4);
        this.addVines(world, box, randomSource, this.config.decorationChances.vineChance, 1, 0, 1, 8, 4, 3);
    }

    private void generateLegs(class_5281 world, class_5819 randomSource, class_3341 box) {
        this.generateLeg(world, randomSource, box, 1, 1, this.config.blockStateRandomizers.brickRandomizer);
        this.generateLeg(world, randomSource, box, 1, 3, this.config.blockStateRandomizers.brickRandomizer);
        this.generateLeg(world, randomSource, box, 8, 1, this.config.blockStateRandomizers.brickRandomizer);
        this.generateLeg(world, randomSource, box, 8, 3, this.config.blockStateRandomizers.brickRandomizer);
    }

    private void generateIronBarSupports(class_5281 world, class_3341 box, class_5819 randomSource, boolean[][] ceiling) {
        ArrayList<Integer> invalidXs = new ArrayList<Integer>();
        for (int z = 2; z <= 3; ++z) {
            for (int x = 2; x <= 7; ++x) {
                if (invalidXs.contains(x) || !ceiling[x][z] || randomSource.method_43048(5) != 0) continue;
                this.fill(world, box, x, 1, z, x, 3, z, class_2246.field_10576.method_9564());
                invalidXs.add(x);
                ++x;
            }
        }
    }
}

